/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.lgoExImport;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.CommentParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareFactory;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.InputNamesManager;
import DE.siemens.ad.logo.model.LogoHardwareFactory;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.CounterBlock;
import DE.siemens.ad.logo.model.lgoExImport.CAsymPulseGeneratorBlock;
import DE.siemens.ad.logo.model.lgoExImport.CBlock;
import DE.siemens.ad.logo.model.lgoExImport.CClockBlock;
import DE.siemens.ad.logo.model.lgoExImport.CCounterBlock;
import DE.siemens.ad.logo.model.lgoExImport.CHoursCounterBlock;
import DE.siemens.ad.logo.model.lgoExImport.COffDelayBlock;
import DE.siemens.ad.logo.model.lgoExImport.COnDelayBlock;
import DE.siemens.ad.logo.model.lgoExImport.CRetentiveOnDelayBlock;
import DE.siemens.ad.logo.model.lgoExImport.CSpecialFunctions;
import DE.siemens.ad.logo.model.lgoExImport.CSymPulseGeneratorBlock;
import DE.siemens.ad.logo.model.lgoExImport.CTriggerBlock;
import DE.siemens.ad.logo.model.lgoExImport.CWipingRelayBlock;
import DE.siemens.ad.logo.model.lgoExImport.CYearClockBlock;
import DE.siemens.ad.logo.model.lgoExImport.ConvertWiringDiagram;
import DE.siemens.ad.logo.model.lgoExImport.PartsOfLgo;
import DE.siemens.ad.logo.model.lgoExImport.Transformer;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.logo.util.ProgressListener;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.util.Hashtable;
import java.util.Vector;

public class Import {
    private static Import fImport = null;
    private static final int MAX_STEPS = 12100;
    private int[][] fProgrammArray = null;
    private int[][] fParameterArray = null;
    private int[] fAnkerArray = null;
    private int[] fAnkerOpCodesArray = null;
    private Transformer fTransformer = null;
    private Hardware fHardware = null;
    private Vector fGeneratedBlocks = new Vector(220);
    private static ProgressListener fProgressListener;

    protected Import(String file) throws ProgramException {
        PartsOfLgo pol = new PartsOfLgo(file);
        this.fTransformer = new Transformer(pol);
    }

    protected void addAnchorsToWD(WiringDiagram wd) throws ProgramException {
        int i = 0;
        int d = 0;
        int blockNummer = 0;
        try {
            int[] ankers = this.fTransformer.getUsedAnchors();
            int[][] prog = this.fProgrammArray;
            int[] ankerVorhanden = new int[12];
            for (i = 0; i < ankers.length; ++i) {
                if (ankers[i] == 252 || ankerVorhanden[(blockNummer = this.getBlockNumberOfCode(ankers[i])) - 1 + this.asiCorrection(ankers[i])] != 0) continue;
                this.fGeneratedBlocks.add(wd.createBlock(ankers[i], blockNummer));
                ankerVorhanden[blockNummer - 1 + this.asiCorrection((int)ankers[i])] = 1;
            }
            for (i = 0; i < prog.length; ++i) {
                for (d = 0; d < prog[i].length; ++d) {
                    if (!this.fTransformer.isOutput(prog[i][d]) || ankerVorhanden[(blockNummer = this.getBlockNumberOfCode(prog[i][d])) - 1 + this.asiCorrection(prog[i][d])] != 0) continue;
                    this.fGeneratedBlocks.add(this.getImportedBlock(wd, prog[i][d], blockNummer));
                    ankerVorhanden[blockNummer - 1 + this.asiCorrection((int)prog[i][d])] = 1;
                }
            }
        }
        catch (Exception e) {
            ProgramException pE = new ProgramException();
            pE.newKey("e");
            pE.set("ERROR: Import.addAnchrosToWD\n  values: \t -i:" + i + "\n\t\t\t -d:" + d + "\n\t\t\t -BlockNr." + blockNummer, "e");
            throw pE;
        }
    }

    private void addConnectionsAnchorToAnchor(WiringDiagram wd) {
        int[] anker = this.fAnkerArray;
        int[] ankerCodes = this.fAnkerOpCodesArray;
        for (int i = 0; i < anker.length; ++i) {
            if (!this.fTransformer.isAnchor(anker[i])) continue;
            Block eingang = this.getImportedBlock(wd, anker[i], this.getBlockNumberOfCode(anker[i]));
            Block ausgang = this.getImportedBlock(wd, ankerCodes[i], this.getBlockNumberOfCode(ankerCodes[i]));
            InBlockConnector inConnector = ausgang.getInConnector(0);
            OutBlockConnector outConnector = eingang.getOutConnector(0);
            inConnector.connect(outConnector);
        }
    }

    private void addConnectionsAnchorToFunction(WiringDiagram wd) throws ProgramException {
        int[] anker = this.fAnkerArray;
        int[] ankerCodes = this.fAnkerOpCodesArray;
        int[][] prog = this.fProgrammArray;
        int i = 0;
        try {
            for (i = 0; i < anker.length; ++i) {
                if (!this.fTransformer.isVerweis(anker[i])) continue;
                int blockNummer = anker[i] - 1064;
                int blockCode = prog[blockNummer - 1][0];
                Block ausgang = this.getImportedBlock(wd, blockCode, blockNummer);
                Block eingang = this.getImportedBlock(wd, ankerCodes[i], this.getBlockNumberOfCode(ankerCodes[i]));
                InBlockConnector inConnector = eingang.getInConnector(0);
                OutBlockConnector outConnector = ausgang.getOutConnector(0);
                inConnector.connect(outConnector);
            }
        }
        catch (Exception e) {
            ProgramException pE = new ProgramException();
            pE.newKey("e");
            pE.set("ERROR: Import.addConnectionsAnchorToFunction\n  values: \t -i:" + i, "e");
            throw pE;
        }
    }

    private void addConnectionsAnchorToInput(WiringDiagram wd) {
        int[] anker = this.fAnkerArray;
        int[] ankerCodes = this.fAnkerOpCodesArray;
        for (int i = 0; i < anker.length; ++i) {
            if (!this.fTransformer.isInput(anker[i])) continue;
            Block eingang = this.getImportedBlock(wd, anker[i], this.getBlockNumberOfCode(anker[i]));
            Block ausgang = this.getImportedBlock(wd, ankerCodes[i], this.getBlockNumberOfCode(ankerCodes[i]));
            InBlockConnector inConnector = ausgang.getInConnector(0);
            OutBlockConnector outConnector = eingang.getOutConnector(0);
            inConnector.connect(outConnector);
        }
    }

    private void addConnectionsAnchorToMarker(WiringDiagram wd) {
        int[] usedAnker = this.fTransformer.getUsedAnchors();
        int[] anker = this.fAnkerArray;
        boolean gefunden = false;
        boolean blocknummer = false;
        int[] ankerCodes = this.fAnkerOpCodesArray;
        for (int i = 0; i < anker.length; ++i) {
            if (!this.fTransformer.isMarker(anker[i])) continue;
            Block eingang = this.getImportedBlock(wd, anker[i], this.getBlockNumberOfCode(anker[i]));
            Block ausgang = this.getImportedBlock(wd, ankerCodes[i], this.getBlockNumberOfCode(ankerCodes[i]));
            InBlockConnector inConnector = ausgang.getInConnector(0);
            OutBlockConnector outConnector = eingang.getOutConnector(0);
            inConnector.connect(outConnector);
        }
    }

    private void addConnectionsAnchorToPegel(WiringDiagram wd) {
        int[] usedAnker = this.fTransformer.getUsedAnchors();
        int[] anker = this.fAnkerArray;
        boolean gefunden = false;
        boolean blocknummer = false;
        int[] ankerCodes = this.fAnkerOpCodesArray;
        for (int i = 0; i < anker.length; ++i) {
            if (!this.fTransformer.isPegel(anker[i])) continue;
            Block eingang = this.getImportedBlock(wd, anker[i], this.getBlockNumberOfCode(anker[i]));
            Block ausgang = this.getImportedBlock(wd, ankerCodes[i], this.getBlockNumberOfCode(ankerCodes[i]));
            InBlockConnector inConnector = ausgang.getInConnector(0);
            OutBlockConnector outConnector = eingang.getOutConnector(0);
            inConnector.connect(outConnector);
        }
    }

    private void addConnectionsBlocks(WiringDiagram wd) throws ProgramException {
        int startParameter = this.fTransformer.getFirstParameterLineNumber() - 1;
        int[][] prog = this.fProgrammArray;
        int[][] para = this.fParameterArray;
        int[] verweise = new int[4];
        Block ausgang = null;
        int i = 0;
        int pos = 0;
        boolean keinParameter = true;
        try {
            for (i = 0; i < prog.length; ++i) {
                this.nextProgressBarStep(1);
                Block funktionsBlock = this.getImportedBlock(wd, prog[i][0], i + 1);
                verweise = this.getVerweise(prog[i]);
                if (funktionsBlock == null) continue;
                this.createRemanenzToBlock(funktionsBlock, prog[i]);
                InBlockConnector[] inConnFB = funktionsBlock.getInConnectors();
                boolean usedConn = false;
                for (pos = 0; pos < verweise.length; ++pos) {
                    keinParameter = true;
                    if (verweise[pos] < 1064) {
                        ausgang = this.getImportedBlock(wd, verweise[pos], this.getBlockNumberOfCode(verweise[pos]));
                    }
                    if (verweise[pos] > 1064 && verweise[pos] <= startParameter) {
                        int blockNummer = verweise[pos] - 1064;
                        int blockCode = prog[blockNummer - 1][0];
                        ausgang = this.getImportedBlock(wd, blockCode, blockNummer);
                    }
                    if (verweise[pos] > startParameter) {
                        keinParameter = false;
                        Vector<Block> vec = new Vector<Block>(1);
                        vec.add(funktionsBlock);
                        ConvertWiringDiagram cwd = new ConvertWiringDiagram(vec);
                        CBlock[] cFunktionsBlock = cwd.getAllCBlocks();
                        cFunktionsBlock[0].setBlock(funktionsBlock);
                        int[][] parameters = this.getParameters(cFunktionsBlock[0], para, verweise);
                        cFunktionsBlock[0].setParameters(0, parameters);
                        pos = pos + parameters.length - 1;
                    }
                    if (ausgang != null && keinParameter) {
                        InBlockConnector inConnector = inConnFB[pos];
                        OutBlockConnector outConnector = ausgang.getOutConnector(0);
                        inConnector.connect(outConnector);
                    }
                    if (!(funktionsBlock instanceof CounterBlock)) continue;
                    this.specialForCounterBlock(funktionsBlock, prog[i]);
                }
            }
        }
        catch (Exception e) {
            ProgramException pE = new ProgramException();
            pE.newKey("e");
            pE.setOriginalException(e);
            pE.set("ERROR: Import.addConnectionsBlocks\n  values: \t -i:" + i + "\n\t\t\t -pos:" + pos + "\n\t\t\t -Block." + ausgang, "e");
            throw pE;
        }
    }

    protected void addInputsToWD(WiringDiagram wd) {
        int i;
        int[][] prog = this.fProgrammArray;
        int[] anker = this.fAnkerArray;
        int[] inputVorhanden = new int[16];
        int blockNummer = 0;
        for (i = 0; i < anker.length; ++i) {
            if (!this.fTransformer.isInput(anker[i]) || inputVorhanden[(blockNummer = this.getBlockNumberOfCode(anker[i])) - 1 + this.asiCorrection(anker[i])] != 0) continue;
            this.fGeneratedBlocks.add(this.getImportedBlock(wd, anker[i], blockNummer));
            inputVorhanden[blockNummer - 1 + this.asiCorrection((int)anker[i])] = 1;
        }
        for (i = 0; i < prog.length; ++i) {
            for (int d = 0; d < prog[i].length; ++d) {
                if (!this.fTransformer.isInput(prog[i][d])) continue;
                blockNummer = this.getBlockNumberOfCode(prog[i][d]);
                boolean correctPosition = this.fTransformer.isInputPosition(d);
                if (inputVorhanden[blockNummer - 1 + this.asiCorrection(prog[i][d])] != 0 || !correctPosition) continue;
                this.fGeneratedBlocks.add(this.getImportedBlock(wd, prog[i][d], blockNummer));
                inputVorhanden[blockNummer - 1 + this.asiCorrection((int)prog[i][d])] = 1;
            }
        }
    }

    public void addIOPortComments(LogoDrawing draw) {
        InputNamesManager iNM = draw.getInputNamesManager();
        if (this.isIOPortCommentsAvailable()) {
            String value;
            String key;
            int i;
            Hashtable comments = this.fTransformer.getIOPortComments();
            String[] keys = iNM.getInputNames();
            for (i = 0; i < keys.length; ++i) {
                key = keys[i];
                value = (String)comments.get(key);
                if (value == null) continue;
                iNM.setInputName(key, value);
            }
            keys = iNM.getOutputNames();
            for (i = 0; i < keys.length; ++i) {
                key = keys[i];
                value = (String)comments.get(key);
                if (value == null) continue;
                iNM.setInputName(key, value);
            }
            String[] markerKeys = iNM.getMarkerNames();
            WiringDiagram wd = draw.getWiringDiagram();
            for (int i2 = 0; i2 < markerKeys.length; ++i2) {
                Block block = wd.getBlock(224 + i2, i2 + 1);
                if (block == null) continue;
                BlockFigure figure = draw.getBlockFigure(block);
                CommentParameter cP = figure.getCommentParameter();
                String ke = markerKeys[i2];
                cP.setText((String)comments.get(ke));
            }
        }
        draw.updateInputNames();
        draw.forceUpdate();
    }

    protected void addMarkerfMarkerComments(Block block) {
    }

    protected void addMarkerToWD(WiringDiagram wd) {
        int i;
        int[][] prog = this.fProgrammArray;
        int[] anker = this.fAnkerArray;
        int[] markerVorhanden = new int[4];
        int blockNummer = 0;
        for (i = 0; i < anker.length; ++i) {
            if (!this.fTransformer.isMarker(anker[i]) || markerVorhanden[(blockNummer = this.getBlockNumberOfCode(anker[i])) - 1] != 0) continue;
            this.fGeneratedBlocks.add(this.getImportedBlock(wd, anker[i], blockNummer));
            markerVorhanden[blockNummer - 1] = 1;
        }
        for (i = 0; i < prog.length; ++i) {
            for (int d = 0; d < prog[i].length; ++d) {
                if (!this.fTransformer.isMarker(prog[i][d]) || markerVorhanden[(blockNummer = this.getBlockNumberOfCode(prog[i][d])) - 1] != 0) continue;
                this.fGeneratedBlocks.add(this.getImportedBlock(wd, prog[i][d], blockNummer));
                markerVorhanden[blockNummer - 1] = 1;
            }
        }
    }

    protected void addProgBlocksToWD(WiringDiagram wd) {
        int[][] prog = this.fProgrammArray;
        for (int i = 0; i < prog.length; ++i) {
            if (prog[i][0] == 252) continue;
            this.fGeneratedBlocks.add(wd.createBlock(prog[i][0], i + 1));
        }
    }

    private int asiCorrection(int opCode) {
        if (this.fTransformer.isAsi(opCode)) {
            return 8;
        }
        return 0;
    }

    public static void createNewImport(String file, ProgressListener listener) throws ProgramException {
        if (fImport == null) {
            fImport = new Import(file);
            fProgressListener = listener;
            fProgressListener.setMaximum(12100);
        }
    }

    private void createRemanenzToBlock(Block block, int[] progZeile) {
        BlockParameter parameter;
        boolean[] rem = new boolean[]{false, false, true};
        int[] werte = new int[]{255, 252, 192};
        if (this.fTransformer.getHardwareIDComfort() != 0 && (parameter = block.getParameter()) != null && parameter.getRemanenceAvailable()) {
            parameter.setRemanenceAvailable(true);
            for (int i = 0; i < werte.length; ++i) {
                if (werte[i] != progZeile[1]) continue;
                parameter.getRemanenceObject().setRemanence(rem[i]);
            }
        }
    }

    public static void delReferences() {
        fImport = null;
    }

    protected Block get1ImportedBlock(WiringDiagram wd, int blockCode) {
        Object returnBlock = null;
        if (blockCode < 255 && blockCode != 252) {
            Hardware hw = ((LogoHardwareFactory)HardwareFactory.getInstance()).getHardware(this.fTransformer.getHardwareIDComfort());
            WiringDiagram wdFuerVergleich = new WiringDiagram(hw);
            Block vergleichBlock = null;
            int[] uebergabe = new int[]{blockCode};
            boolean vorhanden = false;
            vergleichBlock = wdFuerVergleich.createBlock(blockCode, this.getBlockNumberOfCode(blockCode));
            String kennung = vergleichBlock.getNumberString();
            for (int i = 0; i < this.fGeneratedBlocks.size(); ++i) {
                Block listenBlock = (Block)this.fGeneratedBlocks.get(i);
                if (!listenBlock.getNumberString().equals(kennung)) continue;
                vorhanden = true;
                return listenBlock;
            }
            if (!vorhanden) {
                return wd.createBlock(blockCode, this.getBlockNumberOfCode(blockCode));
            }
        }
        return null;
    }

    protected int getBlockNumberOfCode(int opcode) {
        if (opcode > 191 && opcode < 204) {
            return opcode - 192 + 1;
        }
        if (opcode > 211 && opcode < 216) {
            return opcode - 212 + 1;
        }
        if (opcode > 223 && opcode < 228) {
            return opcode - 224 + 1;
        }
        if (opcode > 215 && opcode < 224) {
            return opcode - 216 + 1;
        }
        if (opcode > 235 && opcode < 240) {
            return opcode - 236 + 1;
        }
        return 1;
    }

    protected CSpecialFunctions[] getCSpecialBlocksArray() {
        CSpecialFunctions[] possibleCBlocks = new CSpecialFunctions[]{new COnDelayBlock(), new COffDelayBlock(), new CRetentiveOnDelayBlock(), new CSymPulseGeneratorBlock(), new CWipingRelayBlock(), new CAsymPulseGeneratorBlock(), new CTriggerBlock(), new CYearClockBlock(), new CClockBlock(), new CCounterBlock(), new CHoursCounterBlock()};
        return possibleCBlocks;
    }

    protected Block getImportedBlock(WiringDiagram wd, int blockCode, int blockNummer) {
        Object returnBlock = null;
        int i = 0;
        if (blockCode < 255 && blockCode != 252) {
            Hardware hw = this.fHardware;
            WiringDiagram wdFuerVergleich = new WiringDiagram(hw);
            Block vergleichBlock = null;
            int[] uebergabe = new int[]{blockCode};
            boolean vorhanden = false;
            vergleichBlock = wdFuerVergleich.createBlock(blockCode, blockNummer);
            String kennung = vergleichBlock.getNumberString();
            for (i = 0; i < this.fGeneratedBlocks.size(); ++i) {
                Block listenBlock = (Block)this.fGeneratedBlocks.get(i);
                if (!listenBlock.getNumberString().equals(kennung)) continue;
                vorhanden = true;
                return listenBlock;
            }
            if (!vorhanden) {
                Block ret = wd.createBlock(blockCode, this.getBlockNumberOfCode(blockCode));
                return ret;
            }
        }
        return null;
    }

    public WiringDiagram getImportedWD() throws ProgramException {
        try {
            fProgressListener.setSubset(80, this.getAddConnectionsBlocksSteps() + 10);
            this.nextProgressBarStep(1);
            this.initImport();
            Hardware hw = ((LogoHardwareFactory)HardwareFactory.getInstance()).getHardware(this.fTransformer.getHardwareIDComfort());
            WiringDiagram wd = new WiringDiagram(hw);
            this.nextProgressBarStep(1);
            this.addAnchorsToWD(wd);
            this.nextProgressBarStep(1);
            this.addProgBlocksToWD(wd);
            this.nextProgressBarStep(1);
            this.addInputsToWD(wd);
            this.nextProgressBarStep(1);
            this.addMarkerToWD(wd);
            this.nextProgressBarStep(1);
            this.addConnectionsAnchorToAnchor(wd);
            this.addConnectionsAnchorToMarker(wd);
            this.addConnectionsAnchorToInput(wd);
            this.nextProgressBarStep(1);
            this.addConnectionsAnchorToPegel(wd);
            this.nextProgressBarStep(1);
            this.addConnectionsAnchorToFunction(wd);
            this.nextProgressBarStep(1);
            this.addConnectionsBlocks(wd);
            this.nextProgressBarStep(1);
            return wd;
        }
        catch (ProgramException e) {
            e.set("Can not creat Wiringdiagramm", "e");
            throw e;
        }
    }

    private int[][] getParameters(CBlock zielBlock, int[][] paraArray, int[] progZeile) {
        int startParameter = this.fTransformer.getFirstParameterLineNumber() - 1;
        int anzahlParaZeilen = zielBlock.getUsedParaLine();
        int langeParaZeilen = this.fTransformer.getLengthOfParameterLine();
        int[][] parameters = new int[anzahlParaZeilen][langeParaZeilen];
        int zaehler = 0;
        for (int i = 0; i < progZeile.length; ++i) {
            try {
                if (progZeile[i] <= startParameter) continue;
                parameters[zaehler] = paraArray[progZeile[i] - startParameter - 1];
                ++zaehler;
                continue;
            }
            catch (Exception e) {
                System.out.println("Parameter ignored: \t" + zielBlock + "\t Verweis: " + (i + 1) + "\t ParameterNr.:" + (zaehler + 1));
            }
        }
        return parameters;
    }

    public static Import getReferences() {
        return fImport;
    }

    protected int[] getVerweise(int[] progZeile) {
        int start = 2;
        int hwID = this.fTransformer.getHardwareIDComfort();
        int[] verweise = null;
        if (hwID == 0) {
            start = 1;
        }
        verweise = new int[progZeile.length - start];
        int i = 0;
        while (start < progZeile.length) {
            verweise[i] = progZeile[start];
            ++start;
            ++i;
        }
        return verweise;
    }

    private int getAddConnectionsBlocksSteps() {
        int anzahlBlocks = this.fTransformer.getCountOfBlocks();
        if (anzahlBlocks == 0) {
            anzahlBlocks = 1;
        }
        return anzahlBlocks;
    }

    protected void initImport() {
        this.fAnkerArray = this.fTransformer.getAnchor();
        this.fParameterArray = this.fTransformer.getParameter2();
        this.fProgrammArray = this.fTransformer.getProgramm2();
        this.fAnkerOpCodesArray = this.fTransformer.getAnchorsOpCodes();
        this.fHardware = ((LogoHardwareFactory)HardwareFactory.getInstance()).getHardware(this.fTransformer.getHardwareIDComfort());
    }

    public boolean isIOPortCommentsAvailable() {
        return this.fTransformer.isIOPortCommentsAvailable();
    }

    protected void nextProgressBarStep(int steps) {
        if (fProgressListener != null) {
            fProgressListener.increment(steps);
        }
    }

    private void specialForCounterBlock(Block counterBlock, int[] programmZeile) {
        boolean[] rem = new boolean[]{false, false, true};
        int[] werte = new int[]{255, 252, 192};
        if (this.fTransformer.getHardwareIDComfort() != 0) {
            int remStatus = programmZeile[1];
            BlockParameter parameter = counterBlock.getParameter();
            if (parameter != null) {
                parameter.setRemanenceAvailable(true);
                if (programmZeile[1] == 255 || programmZeile[1] == 252) {
                    parameter.getRemanenceObject().setRemanence(false);
                }
                if (programmZeile[1] == 192) {
                    parameter.getRemanenceObject().setRemanence(true);
                }
            }
        }
    }
}

